//决策报表
//报表块自动滚动和刷新功能

// 确保在jQuery加载完成后执行
if (typeof jQuery === 'undefined') {
    console.error('jQuery is required for report auto scroll and refresh functionality.');
} else {
    $(function() {
        // 安全获取表单对象
        var form = (typeof this !== 'undefined' && this.options && this.options.form) ? this.options.form : null;
        
        // 自动滚动功能
        setTimeout(function() {
            var $report = $("div[widgetname=REPORT2]");
            
            // 检查报表元素是否存在
            if ($report.length === 0) {
                console.error('Report element with widgetname=REPORT2 not found.');
                return;
            }
            
            // 获取滚动容器（根据注释中提到的三种情况）
            var $scrollContainer = null;
            var scrollElement = null;
            
            // 情况1: 冻结情况
            if ($report.find("#frozen-center").length > 0) {
                $scrollContainer = $report.find("#frozen-center");
                scrollElement = $report.find(".frozen-center")[0];
                
                // 隐藏冻结区域的滚动条
                $report.find("#frozen-center, #frozen-north").css({
                    'overflow-x': 'hidden',
                    'overflow-y': 'hidden'
                });
            }
            // 情况2: 未冻结且未安装自定义滚动条插件
            else if ($report.find(".reportContent").length > 0) {
                $scrollContainer = $report.find(".reportContent");
                scrollElement = $report.find(".reportContent")[0];
            }
            // 情况3: 未冻结且安装了自定义滚动条插件
            else if ($report.find(".scrollDiv").length > 0) {
                $scrollContainer = $report.find(".scrollDiv");
                scrollElement = $report.find(".scrollDiv")[0];
            }
            
            // 检查是否找到滚动容器
            if (!$scrollContainer || !scrollElement) {
                console.error('Scroll container not found for report.');
                return;
            }
            
            // 隐藏非冻结情况下的滚动条
            $report.find(".reportContent").css({
                'overflow-y': 'hidden',
                'overflow-x': 'hidden'
            });
            
            // 使用闭包避免全局变量冲突
            (function() {
			    var flag = window.flag2; //设置变量flag,每个报表块需保证各不相同
                flag = true; // 控制滚动的暂停和继续
                var oldScrollTop = -1;
                
                // 鼠标悬浮，滚动停止
                $scrollContainer.mouseover(function() {
                    flag = false;
                });
                
                // 鼠标离开，继续滚动
                $scrollContainer.mouseleave(function() {
                    flag = true;
                });
                
                // 自动滚动逻辑
                setInterval(function() {
                    if (flag) {
                        var currentScrollTop = scrollElement.scrollTop;
                        
                        // 如果滚动位置没有变化且不在顶部，重新开始滚动
                        if (currentScrollTop === oldScrollTop && currentScrollTop !== 0) {
                            scrollElement.scrollTop = 0;
                        } else {
                            oldScrollTop = currentScrollTop;
                            scrollElement.scrollTop = currentScrollTop + 1.5;
                        }
                    }
                }, 200); // 以200ms的频率执行
            })();
        }, 500);
        
        // 自动刷新功能 - 每10分钟刷新一次报表块
        if (form) {
            setInterval(function() {
                try {
                    form.options.form.getWidgetByName('REPORT2').gotoPage(1, "{}", true);
                } catch (error) {
                    console.error('Failed to refresh report:', error);
                }
            }, 600000); // 600000毫秒 = 10分钟
        } else {
            console.error('Form object not available for report refresh.');
        }
    });
}